#version 330
#pragma debug(on)

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

in float brightness_geom[];
in float particle_geom_size[];
flat in int texture_index_geom[];

out vec3 uv;
out float brightness_frag;
flat out int texture_index_frag;

uniform ivec2 screen_size;

void main()
{
    if (texture_index_geom[0] == 15)
    {
        EndPrimitive();
    }

    vec4 in_position = gl_in[0].gl_Position;
    int tex_index = texture_index_geom[0];
    float brightness_level = brightness_geom[0];
    vec2 d = vec2(0.5 * particle_geom_size[0]);

    vec2 pixel_offset = vec2(0.0);

    gl_Position = in_position + vec4((vec2( d.x, -d.y) + pixel_offset), vec2(0.0));
    uv = vec3(1.0, 1.0, float(tex_index));
    texture_index_frag = tex_index;
    brightness_frag = brightness_level;
    EmitVertex();

    gl_Position = in_position + vec4((vec2( d.x,  d.y) + pixel_offset), vec2(0.0));
    uv = vec3(1.0, 0.0, float(tex_index));
    texture_index_frag = tex_index;
    brightness_frag = brightness_level;
    EmitVertex();

    gl_Position = in_position + vec4((vec2(-d.x, -d.y) + pixel_offset), vec2(0.0));
    uv = vec3(0.0, 1.0, float(tex_index));
    texture_index_frag = tex_index;
    brightness_frag = brightness_level;
    EmitVertex();

    gl_Position = in_position + vec4((vec2(-d.x,  d.y) + pixel_offset), vec2(0.0));
    uv = vec3(0.0, 0.0, float(tex_index));
    texture_index_frag = tex_index;
    brightness_frag = brightness_level;
    EmitVertex();

    EndPrimitive();
}
